/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.server;

import cofh.core.CoFHCore;
import cofh.core.util.control.IReconfigurableTile;
import cofh.lib.network.packet.IPacketServer;
import cofh.lib.network.packet.PacketBase;
import cofh.lib.util.control.IReconfigurable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SideConfigPacket
extends PacketBase
implements IPacketServer {
    protected BlockPos pos;
    protected IReconfigurable.SideConfig[] sides = new IReconfigurable.SideConfig[]{IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE, IReconfigurable.SideConfig.SIDE_NONE};

    public SideConfigPacket() {
        super(36, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleServer(ServerPlayer player) {
        Level world = player.f_19853_;
        if (!world.m_46749_(this.pos)) {
            return;
        }
        BlockEntity tile = world.m_7702_(this.pos);
        if (tile instanceof IReconfigurableTile) {
            ((IReconfigurableTile)tile).reconfigControl().setSideConfig(this.sides);
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        byte[] bSides = new byte[6];
        for (int i = 0; i < 6; ++i) {
            bSides[i] = (byte)this.sides[i].ordinal();
        }
        buf.m_130087_(bSides);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        byte[] bSides = buf.m_130101_(6);
        if (bSides.length == 6) {
            for (int i = 0; i < 6; ++i) {
                if (bSides[i] > IReconfigurable.SideConfig.VALUES.length) {
                    bSides[i] = 0;
                }
                this.sides[i] = IReconfigurable.SideConfig.VALUES[bSides[i]];
            }
        }
    }

    public static void sendToServer(IReconfigurableTile tile) {
        SideConfigPacket packet = new SideConfigPacket();
        packet.pos = tile.pos();
        packet.sides = tile.reconfigControl().getSideConfig();
        packet.sendToServer();
    }
}

